<?php
/**
 * ADMIN CONFIGURAÇÕES - REFORÇADO & ULTRA RÁPIDO
 */
// Blindagem de Sessão: Configurações antes do start
ini_set('session.cookie_httponly', 1);
ini_set('session.use_only_cookies', 1);

session_start();

// Blindagem contra cache do navegador (evita que o botão "voltar" exponha dados)
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");

function loadConfig() {
    static $config = null;
    if ($config !== null) return $config;
    
    $file = 'config.json';
    if (!file_exists($file)) {
        return ['usuario' => 'admin', 'senha' => '123456', 'logo' => 'img/logo.png'];
    }
    $config = json_decode(file_get_contents($file), true);
    return $config;
}

function saveConfig($config) {
    file_put_contents('config.json', json_encode($config, JSON_PRETTY_PRINT));
}

$config = loadConfig();
$success_message = isset($_SESSION['success_message']) ? $_SESSION['success_message'] : '';
unset($_SESSION['success_message']); 

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['new_username'], $_POST['new_password'])) {
    $config['usuario'] = $_POST['new_username'];
    $config['senha'] = $_POST['new_password'];
    $uploadOk = 1;

    if (isset($_FILES['new_logo']) && $_FILES['new_logo']['error'] == UPLOAD_ERR_OK) {
        $target_dir = "img/"; 
        if (!is_dir($target_dir)) mkdir($target_dir, 0755, true);

        $file_extension = strtolower(pathinfo($_FILES["new_logo"]["name"], PATHINFO_EXTENSION));
        $new_file_name = "logo_" . time() . "." . $file_extension;
        $target_file = $target_dir . $new_file_name;

        $check = getimagesize($_FILES["new_logo"]["tmp_name"]);
        if ($check === false) { $error_message = "Arquivo inválido."; $uploadOk = 0; }
        if ($_FILES["new_logo"]["size"] > 2000000) { $error_message = "Máximo 2MB."; $uploadOk = 0; }

        if ($uploadOk == 1) {
            if (file_exists($config['logo']) && strpos($config['logo'], 'default') === false) {
                @unlink($config['logo']);
            }
            if (move_uploaded_file($_FILES["new_logo"]["tmp_name"], $target_file)) {
                $config['logo'] = $target_file; 
            } else { $uploadOk = 0; }
        }
    }

    if ($uploadOk == 1) {
        saveConfig($config);
        $_SESSION['success_message'] = "Configurações salvas!";
        // Redireciona para o próprio arquivo para evitar re-envio de formulário
        header("Location: admin.php");
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="pt-br" class="scroll-smooth">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Admin Perfil</title>
  
  <style>
    html.dark { background-color: #030712 !important; }
    html { background-color: #f9fafb; }
    body { visibility: hidden; } 
    body.ready { visibility: visible; }
  </style>

  <script src="https://cdn.tailwindcss.com"></script>
  <script>
    (function() {
        const theme = localStorage.getItem('theme');
        if (theme === 'dark' || (!theme && window.matchMedia('(prefers-color-scheme: dark)').matches)) {
            document.documentElement.classList.add('dark');
        } else {
            document.documentElement.classList.remove('dark');
        }
    })();

    tailwind.config = { 
        darkMode: 'class',
        theme: {
            extend: {
                colors: {
                    dark: { 950: '#030712' }
                }
            }
        }
    }
  </script>
</head>
<body class="bg-gray-50 dark:bg-dark-950 text-gray-900 dark:text-gray-100 transition-colors duration-300 antialiased">

  <header class="w-full h-16 bg-white/80 dark:bg-gray-900/80 backdrop-blur-md shadow-sm border-b border-gray-200 dark:border-gray-800 flex items-center justify-between px-6 sticky top-0 z-50">
    <div class="flex items-center gap-4">
      <button id="menuToggle" class="md:hidden p-2 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-800 transition-colors">☰</button>
      <div class="text-xl font-extrabold tracking-tight bg-gradient-to-r from-blue-600 to-indigo-500 bg-clip-text text-transparent">CONTA ADMIN</div>
    </div>

    <div class="flex items-center gap-3">
      <button id="toggleDark" class="w-10 h-10 flex items-center justify-center bg-gray-100 dark:bg-gray-800 rounded-full hover:ring-2 ring-blue-500 transition-all">
        <span class="dark:hidden">🌙</span><span class="hidden dark:inline">☀️</span>
      </button>
      <div class="h-8 w-px bg-gray-200 dark:bg-gray-700 mx-2"></div>
      <span class="hidden sm:block font-medium text-sm text-gray-600 dark:text-gray-400">@<?php echo htmlspecialchars($config['usuario']); ?></span>
    </div>
  </header>

  <div class="flex">
    <aside id="sidebar" class="w-64 bg-white dark:bg-gray-900 h-[calc(100vh-4rem)] border-r border-gray-200 dark:border-gray-800 fixed md:static top-16 left-0 transform -translate-x-full md:translate-x-0 transition-transform duration-300 z-40">
      <nav class="p-4 space-y-1">
        <a href="dashboard.php" class="flex items-center gap-3 p-3 rounded-xl hover:bg-gray-100 dark:hover:bg-gray-800 transition-all">
          <span>🏠</span> <span class="font-medium">Dashboard</span>
        </a>
        <a href="servidores.php" class="flex items-center gap-3 p-3 rounded-xl hover:bg-gray-100 dark:hover:bg-gray-800 transition-all">
          <span>🖥</span> <span class="font-medium">Servidores</span>
        </a>
        <a href="admin.php" class="flex items-center gap-3 p-3 rounded-xl bg-blue-600 text-white shadow-lg shadow-blue-500/30">
          <span>👤</span> <span class="font-bold">Admin</span>
        </a>
        <div class="py-4"><hr class="border-gray-100 dark:border-gray-800"></div>
        <a href="logoutvs.php" class="flex items-center gap-3 p-3 rounded-xl text-red-500 hover:bg-red-50 dark:hover:bg-red-900/20 transition-all">
          <span>🚪</span> <span class="font-bold">Sair</span>
        </a>
      </nav>
    </aside>

    <main class="flex-1 p-4 md:p-8 w-full max-w-5xl mx-auto"> 
      <div class="bg-white dark:bg-gray-900 rounded-3xl shadow-sm border border-gray-200 dark:border-gray-800 p-6 md:p-10">
        <div class="mb-8">
            <h2 class="text-3xl font-black text-gray-800 dark:text-white tracking-tight">Configurações</h2>
            <p class="text-gray-500 dark:text-gray-400">Gerencie credenciais e identidade visual.</p>
        </div>

        <?php if (isset($error_message)): ?>
            <div class="flex items-center gap-3 bg-red-50 border border-red-100 text-red-600 p-4 mb-6 rounded-2xl">
                <span>⚠️</span> <?php echo htmlspecialchars($error_message); ?>
            </div>
        <?php endif; ?>

        <?php if ($success_message): ?>
            <div id="success-message" class="flex items-center gap-3 bg-emerald-50 border border-emerald-100 text-emerald-600 p-4 mb-6 rounded-2xl">
                <span>✅</span> <?php echo htmlspecialchars($success_message); ?>
            </div>
        <?php endif; ?>

        <form method="post" action="" class="space-y-8" enctype="multipart/form-data">
            <div class="grid md:grid-cols-2 gap-8">
                <div class="space-y-2">
                    <label class="text-xs font-bold text-gray-400 uppercase tracking-widest ml-1">Usuário do Painel</label>
                    <input type="text" name="new_username" value="<?php echo htmlspecialchars($config['usuario']); ?>" required class="w-full p-4 bg-gray-50 dark:bg-gray-800 border border-gray-200 dark:border-gray-700 rounded-2xl focus:ring-4 ring-blue-500/10 focus:border-blue-500 outline-none transition-all dark:text-white font-medium">
                </div>
                <div class="space-y-2">
                    <label class="text-xs font-bold text-gray-400 uppercase tracking-widest ml-1">Senha do Painel</label>
                    <input type="text" name="new_password" value="<?php echo htmlspecialchars($config['senha']); ?>" required class="w-full p-4 bg-gray-50 dark:bg-gray-800 border border-gray-200 dark:border-gray-700 rounded-2xl focus:ring-4 ring-blue-500/10 focus:border-blue-500 outline-none transition-all dark:text-white font-medium">
                </div>
            </div>

            <div class="bg-gray-50 dark:bg-gray-800/50 p-6 rounded-3xl border border-gray-200 dark:border-gray-700">
                <label class="block text-sm font-bold text-gray-700 dark:text-gray-300 mb-4">Identidade Visual</label>
                <div class="flex flex-col md:flex-row items-center gap-8">
                    <div class="relative group">
                        <img src="<?php echo htmlspecialchars($config['logo']); ?>?t=<?php echo time(); ?>" alt="Logo" class="h-28 w-28 object-contain bg-white rounded-2xl p-4 shadow-sm border border-gray-100 transition-transform group-hover:scale-105">
                        <div class="absolute -top-2 -right-2 bg-blue-600 text-white text-[10px] font-bold px-2 py-1 rounded-full uppercase">Atual</div>
                    </div>
                    <div class="flex-1 w-full">
                        <p class="text-xs text-gray-500 mb-3">Recomendado: PNG ou SVG transparente (máx. 2MB)</p>
                        <input type="file" name="new_logo" accept="image/*" class="block w-full text-sm text-gray-500 file:mr-4 file:py-2.5 file:px-6 file:rounded-xl file:border-0 file:text-xs file:font-bold file:bg-blue-600 file:text-white hover:file:bg-blue-700 transition-all cursor-pointer">
                    </div>
                </div>
            </div>
            
            <button type="submit" class="w-full py-4 bg-blue-600 hover:bg-blue-700 text-white font-black rounded-2xl shadow-xl shadow-blue-500/30 transition-all active:scale-[0.98] uppercase tracking-widest">
                Confirmar Alterações
            </button>
        </form>
      </div>
    </main>
  </div>

  <script>
    document.body.classList.add('ready');

    const toggleDark = document.getElementById('toggleDark');
    const html = document.documentElement;

    toggleDark.addEventListener('click', () => {
      const isDark = html.classList.toggle('dark');
      localStorage.setItem('theme', isDark ? 'dark' : 'light');
    });

    document.getElementById('menuToggle').addEventListener('click', () => {
      document.getElementById('sidebar').classList.toggle('-translate-x-full');
    });

    const msg = document.getElementById('success-message');
    if (msg) {
        setTimeout(() => {
            msg.style.transition = "all 0.5s ease";
            msg.style.opacity = "0";
            msg.style.transform = "translateY(-10px)";
            setTimeout(() => msg.remove(), 500);
        }, 3000);
    }
  </script>
</body>
</html>